CONTAINER Mmaterial
{
	NAME Mmaterial;

	INCLUDE Mpreview;
	INCLUDE Mbase;

	GROUP Obaselist
	{
		GROUP
		{
			COLUMNS 2; MATEDCOLUMNS 1;

			BOOL MATERIAL_USE_COLOR 				{ PARENTMSG ID_MATERIALGROUP_COLOR; }
			BOOL MATERIAL_USE_DIFFUSION			{ PARENTMSG ID_MATERIALGROUP_DIFFUSION; }
			BOOL MATERIAL_USE_LUMINANCE			{ PARENTMSG ID_MATERIALGROUP_LUMINANCE; }
			BOOL MATERIAL_USE_TRANSPARENCY	{ PARENTMSG ID_MATERIALGROUP_TRANSPARENCY; }
			BOOL MATERIAL_USE_REFLECTION		{ PARENTMSG ID_MATERIALGROUP_REFLECTION; }
			BOOL MATERIAL_USE_ENVIRONMENT		{ PARENTMSG ID_MATERIALGROUP_ENVIRONMENT; }
			BOOL MATERIAL_USE_FOG						{ PARENTMSG ID_MATERIALGROUP_FOG; }
			BOOL MATERIAL_USE_BUMP					{ PARENTMSG ID_MATERIALGROUP_BUMP; }
			BOOL MATERIAL_USE_NORMAL				{ PARENTMSG ID_MATERIALGROUP_NORMAL; }
			BOOL MATERIAL_USE_ALPHA					{ PARENTMSG ID_MATERIALGROUP_ALPHA; }
			BOOL MATERIAL_USE_GLOW					{ PARENTMSG ID_MATERIALGROUP_GLOW; }
			BOOL MATERIAL_USE_DISPLACEMENT	{ PARENTMSG ID_MATERIALGROUP_DISPLACEMENT; }
			BOOL MATERIAL_PAGE_EDITOR				{ PAGE; HIDDEN; PARENTMSG ID_MATERIALGROUP_EDITOR; }
			BOOL MATERIAL_PAGE_CUSTOM				{ PAGE; HIDDEN; PARENTMSG ID_MATERIALGROUP_CUSTOM; }
		}
	}

	GROUP ID_MATERIALGROUP_COLOR
	{
		DEFAULT 1;
		COLOR	MATERIAL_COLOR_COLOR { OPEN; }
		REAL 	MATERIAL_COLOR_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		SHADERLINK MATERIAL_COLOR_SHADER { }
		LONG MATERIAL_COLOR_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_COLOR_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { LINE; }

		LONG MATERIAL_COLOR_MODEL 			{ CYCLE { MATERIAL_COLOR_MODEL_LAMBERTIAN; MATERIAL_COLOR_MODEL_ORENNAYAR; } }
		REAL MATERIAL_COLOR_DIFFUSEFALLOFF	{ UNIT PERCENT; MIN -1000.0; MAX 1000.0; MINSLIDER -100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL MATERIAL_COLOR_DIFFUSELEVEL		{ UNIT PERCENT; MIN 0.0; MAX 1000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL MATERIAL_COLOR_ROUGHNESS 		{ UNIT PERCENT; MIN 0.0; MAX 200.0; MAXSLIDER 200.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP ID_MATERIALGROUP_DIFFUSION
	{
		REAL  MATERIAL_DIFFUSION_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		BOOL  MATERIAL_DIFFUSION_AFFECT_LUMINANCE { }
		BOOL  MATERIAL_DIFFUSION_AFFECT_SPECULAR { }
		BOOL  MATERIAL_DIFFUSION_AFFECT_REFLECTION { }
		SEPARATOR { }
		SHADERLINK MATERIAL_DIFFUSION_SHADER { }
		LONG MATERIAL_DIFFUSION_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_DIFFUSION_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP ID_MATERIALGROUP_LUMINANCE
	{
		COLOR	MATERIAL_LUMINANCE_COLOR { OPEN; }
		REAL 	MATERIAL_LUMINANCE_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		SHADERLINK MATERIAL_LUMINANCE_SHADER { }
		LONG MATERIAL_LUMINANCE_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_LUMINANCE_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP ID_MATERIALGROUP_TRANSPARENCY
	{
		COLOR	MATERIAL_TRANSPARENCY_COLOR { OPEN; }
		REAL 	MATERIAL_TRANSPARENCY_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		LONG MATERIAL_TRANSPARENCY_REFRACTION_PRESET
		{
			ANIM OFF;
			CYCLE
			{ 
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_CUSTOM;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_BEER;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_DIAMOND;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_EMERALD;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_ETHANOL;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_GLASS;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_JADE;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_MILK;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_OIL_VEGETABLE;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_PEARL;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_PET;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_PLEXIGLASS;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_RUBY;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_SAPPHIRE;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_WATER;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_WATER_ICE;
				MATERIAL_TRANSPARENCY_REFRACTION_PRESET_WHISKEY;
			}
		}
		REAL  MATERIAL_TRANSPARENCY_REFRACTION { MIN 0.25; MAX 4.0; STEP 0.01; }
		BOOL  MATERIAL_TRANSPARENCY_FRESNEL { }
		BOOL MATERIAL_TRANSPARENCY_EXITREFLECTIONS { }
		//COLOR MATERIAL_TRANSPARENCY_EXITCOLOR	{ }
		REAL  MATERIAL_TRANSPARENCY_FRESNELREFLECTIVITY { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		BOOL  MATERIAL_TRANSPARENCY_ADDITIVE { }
		SEPARATOR { }
		SHADERLINK MATERIAL_TRANSPARENCY_SHADER { }
		LONG MATERIAL_TRANSPARENCY_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_TRANSPARENCY_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { LINE; }
		COLOR MATERIAL_TRANSPARENCY_ABSORPTIONCOLOR	{ }
		REAL MATERIAL_TRANSPARENCY_ABSORPTIONDISTANCE { UNIT METER; MIN 0.0; }
		SEPARATOR { LINE; }

		REAL  MATERIAL_TRANSPARENCY_DISPERSION { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		LONG  MATERIAL_TRANSPARENCY_MINSAMPLES { PARENTID MATERIAL_TRANSPARENCY_DISPERSION; MIN 1; MAX 10000; }
		LONG  MATERIAL_TRANSPARENCY_MAXSAMPLES { PARENTID MATERIAL_TRANSPARENCY_DISPERSION; MIN 1; MAX 10000; }
		REAL  MATERIAL_TRANSPARENCY_ACCURACY   { PARENTID MATERIAL_TRANSPARENCY_DISPERSION; UNIT PERCENT; MIN 0.0; MAX 100.0; }
	}

	GROUP ID_MATERIALGROUP_REFLECTION
	{
		COLOR MATERIAL_REFLECTION_COLOR 		{ HIDDEN; }
		REAL MATERIAL_REFLECTION_BRIGHTNESS 		{ HIDDEN; UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		BOOL MATERIAL_REFLECTION_ADDITIVE 		{ HIDDEN; }
		BOOL MATERIAL_REFLECTION_USE_BUMP 		{ HIDDEN; }
		SHADERLINK MATERIAL_REFLECTION_SHADER 		{ HIDDEN; }
		LONG MATERIAL_REFLECTION_TEXTUREMIXING 		{ HIDDEN; CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; 		MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_REFLECTION_TEXTURESTRENGTH 	{ HIDDEN; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL  MATERIAL_REFLECTION_DISPERSION 		{ HIDDEN; UNIT PERCENT; MIN 0.0; MAX 100.0; }
		LONG  MATERIAL_REFLECTION_MINSAMPLES		{ HIDDEN; PARENTID MATERIAL_REFLECTION_DISPERSION; MIN 1; MAX 10000; }
		LONG  MATERIAL_REFLECTION_MAXSAMPLES 		{ HIDDEN; PARENTID MATERIAL_REFLECTION_DISPERSION; MIN 1; MAX 10000; }
		REAL  MATERIAL_REFLECTION_ACCURACY   		{ HIDDEN; PARENTID MATERIAL_REFLECTION_DISPERSION; UNIT PERCENT; MIN 0.0; MAX 100.0; }
	}

	GROUP ID_MATERIALGROUP_ENVIRONMENT
	{
		COLOR MATERIAL_ENVIRONMENT_COLOR { OPEN; }
		REAL MATERIAL_ENVIRONMENT_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		SHADERLINK MATERIAL_ENVIRONMENT_SHADER { }
		LONG MATERIAL_ENVIRONMENT_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_ENVIRONMENT_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		REAL MATERIAL_ENVIRONMENT_TILESX { MIN 0.0; STEP 0.01; }
		REAL MATERIAL_ENVIRONMENT_TILESY { MIN 0.0; STEP 0.01; }
		BOOL MATERIAL_ENVIRONMENT_EXCLUSIVE { }
	}

	GROUP ID_MATERIALGROUP_FOG
	{
		COLOR MATERIAL_FOG_COLOR	{ OPEN; }
		REAL MATERIAL_FOG_BRIGHTNESS	{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL MATERIAL_FOG_DISTANCE	{ UNIT METER; MIN 0.0; }
	}

	GROUP ID_MATERIALGROUP_BUMP
	{
		REAL MATERIAL_BUMP_STRENGTH { UNIT PERCENT; MIN -1000000.0; MAX 1000000.0; MINSLIDER -100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;   }
		BOOL MATERIAL_BUMP_MIPFALLOFF	{ }
		SEPARATOR { }
		SHADERLINK MATERIAL_BUMP_SHADER { }
	}

	GROUP ID_MATERIALGROUP_NORMAL
	{
		REAL MATERIAL_NORMAL_STRENGTH { UNIT PERCENT; MIN 0.0; MAX 100000.0; }
		LONG MATERIAL_NORMAL_SPACE	{ CYCLE { MATERIAL_NORMAL_SPACE_TANGENT; MATERIAL_NORMAL_SPACE_LOCAL; MATERIAL_NORMAL_SPACE_WORLD; } }
		BOOL MATERIAL_NORMAL_REVERSEX	{}
		BOOL MATERIAL_NORMAL_REVERSEY	{}
		BOOL MATERIAL_NORMAL_REVERSEZ {}
		BOOL MATERIAL_NORMAL_SWAP {}
		SEPARATOR { }
		SHADERLINK MATERIAL_NORMAL_SHADER { }
	}

	GROUP ID_MATERIALGROUP_ALPHA
	{
		COLOR MATERIAL_ALPHA_COLOR { }
		COLOR MATERIAL_ALPHA_DELTA { }
		BOOL MATERIAL_ALPHA_INVERT { }
		BOOL MATERIAL_ALPHA_SOFT { }
		BOOL MATERIAL_ALPHA_IMAGEALPHA { }
		BOOL MATERIAL_ALPHA_PREMULTIPLIED	{ }
		SEPARATOR { }
		SHADERLINK MATERIAL_ALPHA_SHADER { }
	}

	GROUP ID_MATERIALGROUP_SPECULAR
	{
		HIDDEN;
		COLOR MATERIAL_SPECULAR_COLOR 			{ HIDDEN; }
		REAL MATERIAL_SPECULAR_BRIGHTNESS		{ HIDDEN; UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		SHADERLINK MATERIAL_SPECULAR_SHADER		{ HIDDEN; }
		LONG MATERIAL_SPECULAR_TEXTUREMIXING 		{ HIDDEN; CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_SPECULAR_TEXTURESTRENGTH 		{ HIDDEN; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		LONG MATERIAL_SPECULAR_MODE			{ HIDDEN; CYCLE { MATERIAL_SPECULAR_MODE_PLASTIC; MATERIAL_SPECULAR_MODE_METAL; MATERIAL_SPECULAR_MODE_COLORED; } }
		REAL MATERIAL_SPECULAR_WIDTH 			{ HIDDEN; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL MATERIAL_SPECULAR_HEIGHT 			{ HIDDEN; UNIT PERCENT; MIN 0.0; MAX 1000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL MATERIAL_SPECULAR_FALLOFF 			{ HIDDEN; UNIT PERCENT; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL MATERIAL_SPECULAR_INNERWIDTH 		{ HIDDEN; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP ID_MATERIALGROUP_GLOW
	{
		COLOR MATERIAL_GLOW_COLOR	{ }
		REAL MATERIAL_GLOW_BRIGHTNESS	{ UNIT PERCENT; MIN 0.0; MAX 100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL MATERIAL_GLOW_INNERSTRENGTH { UNIT PERCENT; MIN 0.0; MAX 10000.0; }
		REAL MATERIAL_GLOW_OUTERSTRENGTH { UNIT PERCENT; MIN 0.0; MAX 10000.0; }
		REAL MATERIAL_GLOW_RADIUS { UNIT METER; MIN 0.0; }
		REAL MATERIAL_GLOW_RANDOM	{ UNIT PERCENT; MIN 0.0; MAX 100.0; }
		REAL MATERIAL_GLOW_FREQUENCY { MIN 0.0; STEP 0.01; }
		BOOL MATERIAL_GLOW_USEMATERIALCOLOR { }
	}

	GROUP ID_MATERIALGROUP_DISPLACEMENT
	{
		REAL MATERIAL_DISPLACEMENT_STRENGTH	{ UNIT PERCENT; MIN -100.0; MAX 100.0;  CUSTOMGUI REALSLIDER;  }
		REAL MATERIAL_DISPLACEMENT_HEIGHT { UNIT METER; }
		LONG MATERIAL_DISPLACEMENT_TYPE { CYCLE { MATERIAL_DISPLACEMENT_TYPE_INTENSITY; MATERIAL_DISPLACEMENT_TYPE_CENTEREDINTENSITY; MATERIAL_DISPLACEMENT_TYPE_REDGREEN; MATERIAL_DISPLACEMENT_TYPE_RGBTANGENT; MATERIAL_DISPLACEMENT_TYPE_RGBLOCAL; MATERIAL_DISPLACEMENT_TYPE_RGBWORLD; } }
		SEPARATOR { }
		SHADERLINK MATERIAL_DISPLACEMENT_SHADER { }
		SEPARATOR { }

		GROUP ID_MATERIALGROUP_SUBPOLY
		{
			COLUMNS 1; DEFAULT 1;

			BOOL MATERIAL_DISPLACEMENT_SUBPOLY { }
			LONG MATERIAL_DISPLACEMENT_SUBPOLY_SUBDIVISION { MIN 1; MAX 12; }
			BOOL MATERIAL_DISPLACEMENT_SUBPOLY_ROUND { }
			BOOL MATERIAL_DISPLACEMENT_SUBPOLY_ROUNDCONTOUR { }
			BOOL MATERIAL_DISPLACEMENT_SUBPOLY_HQREMAPPING { }
			BOOL MATERIAL_DISPLACEMENT_SUBPOLY_MAPRESULT { }
			BOOL MATERIAL_DISPLACEMENT_SUBPOLY_KEEPEDGES { }
			BOOL MATERIAL_DISPLACEMENT_SUBPOLY_DISTRIBUTION { }
		}
	}

	GROUP ID_MATERIALGROUP_CUSTOM
	{
	}

	INCLUDE Millum;

	GROUP ID_MATERIALGROUP_ILLUMINATION
	{
	}
	
	GROUP ID_MATERIALGROUP_EDITOR
	{
		BOOL MATERIAL_ANIMATEPREVIEW { }

		LONG MATERIAL_PREVIEWSIZE
		{
			CYCLE
			{
				MATERIAL_PREVIEWSIZE_DEF;
				MATERIAL_PREVIEWSIZE_NO_SCALE;
				MATERIAL_PREVIEWSIZE_64;
				MATERIAL_PREVIEWSIZE_128;
				MATERIAL_PREVIEWSIZE_256;
				MATERIAL_PREVIEWSIZE_512;
				MATERIAL_PREVIEWSIZE_1024;
				MATERIAL_PREVIEWSIZE_2048;
				MATERIAL_PREVIEWSIZE_4096;
				MATERIAL_PREVIEWSIZE_8192;
				MATERIAL_PREVIEWSIZE_16384;
			}
		}
		
		TEXT_SEPARATOR MATERIAL_DISPLAY_USE_SHADER_EOGL { SNAME MATERIAL_DISPLAY_USE_SHADER_EOGL_NAME; NEWLINE; }
		LONG MATERIAL_EDITORDISPLAY
		{
			CYCLE
			{
				MATERIAL_EDITORDISPLAY_COMBINED;
				MATERIAL_EDITORDISPLAY_COLOR;
				MATERIAL_EDITORDISPLAY_DIFFUSION;
				MATERIAL_EDITORDISPLAY_LUMINANCE;
				MATERIAL_EDITORDISPLAY_TRANSPARENCY;
				//MATERIAL_EDITORDISPLAY_REFLECTANCE;
				MATERIAL_EDITORDISPLAY_ENVIRONMENT;
				MATERIAL_EDITORDISPLAY_BUMP;
				MATERIAL_EDITORDISPLAY_ALPHA;
				//MATERIAL_EDITORDISPLAY_SPECULARCOLOR;
				MATERIAL_EDITORDISPLAY_DISPLACEMENT;
				MATERIAL_EDITORDISPLAY_NORMAL;
			}
		}

		GROUP
		{
			COLUMNS 2;
			
			BOOL MATERIAL_DISPLAY_USE_COLOR { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			BOOL MATERIAL_DISPLAY_USE_DIFFUSION { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			BOOL MATERIAL_DISPLAY_USE_LUMINANCE { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			BOOL MATERIAL_DISPLAY_USE_TRANSPARENCY { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			BOOL MATERIAL_DISPLAY_USE_ENVIRONMENT { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			BOOL MATERIAL_DISPLAY_USE_BUMP	{ ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			BOOL MATERIAL_DISPLAY_USE_NORMAL { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			BOOL MATERIAL_DISPLAY_USE_ALPHA { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			//BOOL MATERIAL_DISPLAY_USE_REFLECTANCE { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			//BOOL MATERIAL_DISPLAY_USE_SPECULARCOLOR { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
			//BOOL MATERIAL_DISPLAY_USE_DISPLACEMENT { ANIM OFF; CUSTOMGUI BITMAP_BOOL; }
		}
	}
	INCLUDE Massign;

	GROUP Obaselist
	{
		BUTTON MATERIAL_CUSTOM_ADDCHANNEL {}
	}
}
